//020714 Virtual SPI Port Interface for LTC2348 Demo Board
//Takes output of PCF8574TS I2C port expander and decodes it to create SDI word for LTC2348.
//Also takes LVDS/CMOSL info from port expander
//GMH
`timescale 1ps / 1ps
module VSPI
(
	WRIN,
	WRIN2,
	SDIIN,
	SCKIN,
	CNVIN,
	LVDS_CMOS_IN,
	AUX0,
	AUX1,
	MOSI_OUT,
	LVDS_CMOS_OUT
	);
	
	input WRIN;										//control line for CNV 0=program 1=run
	input WRIN2;									//control line for SPI 0=program 1=run
	input SDIIN;									//virtual SDI from DC890
	input SCKIN;									//virtual SCK from DC890
	input CNVIN;									//virtual CNV from DC890
	input LVDS_CMOS_IN;							//1=LVDS 0=CMOS
	input AUX0;										//future use
	input AUX1;										//future use
	output [23:0] MOSI_OUT;						//MOSI word for serial_io module
	output LVDS_CMOS_OUT;						//1=LVDS 0=CMOS
	
	wire WRIN;
	wire WRIN2;
	wire SDIIN;
	wire SCKIN;
	wire CNVIN;
	wire LVDS_CMOS_IN;
	wire AUX0;
	wire AUX1;
	reg [23:0] MOSI_OUT;
	reg [23:0] mosi;
	reg LVDS_CMOS_OUT;
	
	always @(posedge SCKIN) begin 			
	mosi <= {SDIIN,mosi[23:1]};				// latch data bit, place in proper location of dout
	end 
	
	always @(posedge CNVIN) begin
	MOSI_OUT <= mosi;
	LVDS_CMOS_OUT <= LVDS_CMOS_IN;
	end
	
	endmodule